/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.rewrites.chunksystem.common;

import com.ishland.c2me.base.common.config.ConfigSystem;

public class Config {
    public static final boolean asyncSerialization = new ConfigSystem.ConfigAccessor().key("chunkSystem.asyncSerialization").comment("Whether to enable async serialization\n").getBoolean(true, false);
    public static final boolean recoverFromErrors = new ConfigSystem.ConfigAccessor().key("chunkSystem.recoverFromErrors").comment("Whether to recover from errors when loading chunks \n This will cause errored chunk to be regenerated entirely, which may cause data loss \n Only applies when async chunk loading is enabled\n").getBoolean(false, false);
    public static final boolean allowPOIUnloading = new ConfigSystem.ConfigAccessor().key("chunkSystem.allowPOIUnloading").comment("Whether to allow POIs (Point of Interest) to be unloaded\nUnloaded POIs are reloaded on-demand or when the corresponding chunks are loaded again,\nwhich should not cause any behavior change\n \nNote:\nVanilla never unloads POIs when chunks unload, causing small memory leaks\nThese leaks adds up and eventually cause issues after generating millions of chunks\nin a single world instance\n").getBoolean(true, false);
    public static final boolean suppressGhostMushrooms = new ConfigSystem.ConfigAccessor().key("chunkSystem.suppressGhostMushrooms").comment("This option workarounds MC-276863, a bug that makes mushrooms appear in non-postprocessed chunks\nThis bug is amplified with notickvd as it exposes non-postprocessed chunks to players\n\nThis should not affect other worldgen behavior and game mechanics in general\n").getBoolean(true, false);
    public static final boolean syncPlayerTickets = new ConfigSystem.ConfigAccessor().key("chunkSystem.syncPlayerTickets").comment("Whether to synchronize the management of player tickets\n\nIn vanilla Minecraft, player tickets are not always removed immediately when players leave an area.\nThe delay in removal increases with the chunk system\u2019s throughput, but due to vanilla\u2019s typically\nslow chunk loading, tickets are almost always removed immediately. However, some contraptions rely\non this immediate removal behavior and tend to be broken with the increased chunk throughput.\nEnabling this option synchronizes player ticket handling, making it more predictable and\nthus improving compatibility with these contraptions.\n").getBoolean(true, false);
    public static final boolean fluidPostProcessingToScheduledTick = new ConfigSystem.ConfigAccessor().key("chunkSystem.fluidPostProcessingToScheduledTick").comment("Whether to turn fluid postprocessing into scheduled tick\n\nFluid post-processing is very expensive when loading in new chunks, and this can affect\nMSPT significantly. This option delays fluid post-processing to scheduled tick to hopefully\nmitigate this issue.\n").getBoolean(true, false);
    public static final boolean filterFluidPostProcessing = new ConfigSystem.ConfigAccessor().key("chunkSystem.filterFluidPostProcessing").comment("Whether to filter fluid post-processing on worldgen threads\n\nThe worldgen processes creates a lot of unnecessary fluid post-processing tasks,\nwhich can overload the server thread and cause stutters.\nThis applies a rough filter to filter out fluids that are definitely not going to flow\n").getBoolean(true, false);
    public static final boolean useLegacyScheduling = new ConfigSystem.ConfigAccessor().key("chunkSystem.useLegacyScheduling").comment("Whether to use legacy scheduling for neighbor chunks\n\nEnabling this restores the behavior of always loading in neighbor chunks when a chunk is loaded.\n\nThis is currently deprecated and will be removed in the future.\n").getBoolean(false, false);
    public static final boolean lowMemoryMode = new ConfigSystem.ConfigAccessor().key("chunkSystem.lowMemoryMode").comment("Whether to enable low memory mode\n\nThis option will attempt to aggressively unload unused chunks.\nOnly applies when useLegacyScheduling is disabled.\n").getBoolean(false, false);

    public static void init() {
    }
}

